<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\tabs\TabsX;
use yii\bootstrap\Modal; 
use yii\helpers\Url; 
use kartik\widgets\FileInput;
use yii\web\UploadedFile;
use common\models\UploadForm;
use common\models\Files;
use common\models\Packetcommands;
use kartik\select2\Select2;
use backend\models\Admin;
use kartik\popover\PopoverX;
use yii\bootstrap\Collapse;
use yii\web\JsExpression;

/* @var $this yii\web\View */
/* @var $model common\models\Bots */
/* @var $form yii\widgets\ActiveForm */

$this->title = 'Packet task '.$model->name;
$this->params['breadcrumbs'][] = $this->title;

$packetcommandtype = [
    'runbot'=>'Run bot command',
    'setvar'=>'Set Variable',
    'ifgoto'=>'IF GOTO',
    'ifexit'=>'IF EXIT',
    'increment'=>'++',
    'decrement'=>'--',
];

$condition = [
    'isnull'=>'is null',
    'isnotnull'=>'is not null',
    'contain'=>'contain',
    'lt'=>'<',
    'gt'=>'>',
    'equal'=>'=',
    'notequal'=>'<>',
    
];

$vars = [];
$defvar = '';
$varsQuery = Packetcommands::find(['task_id' => $model->id])->orderBy(['varname' => SORT_ASC])->select('varname')->asArray()->distinct()->all();

foreach ($varsQuery as $key => $value) {
    if($value['varname']!=''){
        $vars[$value['varname']] = $value['varname'];
        if($defvar==''){
            $defvar = $value['varname'];
        }
    }
}

?>
<style type="text/css">

.content-wrapper {
    /*background: url('images/bot1.jpg') !important;
    background-repeat: no-repeat !important;
    background-size: cover !important;
    opacity: 0.8;*/
    background: white !important;
}


.content{
    overflow-x: scroll;
}


.breadcrumb a{
    color:black !important;
    font-weight: bold;
    text-decoration: underline !important;
}


</style>


<div class="container">
    <?php $form = ActiveForm::begin(['options' => ['enctype' => 'multipart/form-data'], 'id' => 'packetform']); ?>

        <table class="special_form1" style="text-align: center;">
        <tbody>
            <tr>
                <td id="step" style="width: 90px;">
                    <!-- step ---------------------------------- -->
                    <label id="step-label" class="control-label">Line №</label>&nbsp;
                    <?= PopoverX::widget([
                        'header' => false,
                        'options' => ['id' => 'options-area'],
                        'size' => PopoverX::SIZE_MEDIUM,
                        'placement' => PopoverX::ALIGN_RIGHT_TOP,
                        'content' => 'Line number (Similar as Basic)' ,
                        'footer' => false,
                        'toggleButton' => ['label'=>false, 'class'=>'glyphicon glyphicon-question-sign', 'tag' => 'span'],
                    ]); ?>
                    
                    <?= $form->field($model, 'field20')->textInput(['value'=> Packetcommands::Newline($model), 'class' => "special_form1 form-control selectpacketcommand"])->label(false); ?>
                </td>
                <td id="packetcommandtype" style="min-width: 180px;">
                    <!-- command ---------------------------------- -->
                    <label class="control-label">Packet Command</label>&nbsp;
                        <?= PopoverX::widget([
                            'header' => false,
                            'size' => PopoverX::SIZE_LARGE,
                            'placement' => PopoverX::ALIGN_RIGHT_TOP,
                            'content' => '' ,
                            'footer' => false,
                            'toggleButton' => ['label'=>false, 'class'=>'glyphicon glyphicon-question-sign', 'tag' => 'span'],
                        ]); ?>
                    <?= $form->field($model, 'field21')->widget(Select2::classname(), [
                        'data' => $packetcommandtype,
                        'options' => ['onchange' => 'initpacketcommand()'],
                        'pluginOptions' => [
                            'id' => 'packetcommandtype',
                            'name' => 'packetcommandtype',
                            'data' => $packetcommandtype,
                            ]
                        ])->label(false); ?>    
                    
                </td>




                <td id="setvarname" style="min-width: 160px;">
                    <label id="setvarname-label" class="control-label">Put result to variable</label>&nbsp;
                    <?= PopoverX::widget([
                        'header' => false,
                        'options' => ['id' => 'options-area'],
                        'size' => PopoverX::SIZE_MEDIUM,
                        'placement' => PopoverX::ALIGN_LEFT_TOP,
                        'content' => '' ,
                        'footer' => false,
                        'toggleButton' => ['label'=>false, 'class'=>'glyphicon glyphicon-question-sign', 'tag' => 'span'],
                    ]); ?>
                    
                    <?= $form->field($model, 'field22')->textInput(['class' => "special_form1 form-control selectpacketcommand"])->label(false); ?>
                    
                </td>
                <td id="setvarvalue" class="hidetab" style="min-width: 160px;">
                    <!-- arg1 ---------------------------------- -->
                    <label id="setvarvalue-label" class="control-label">Put result to variable</label>&nbsp;
                    <?= PopoverX::widget([
                        'header' => false,
                        'options' => ['id' => 'options-area'],
                        'size' => PopoverX::SIZE_MEDIUM,
                        'placement' => PopoverX::ALIGN_LEFT_TOP,
                        'content' => '' ,
                        'footer' => false,
                        'toggleButton' => ['label'=>false, 'class'=>'glyphicon glyphicon-question-sign', 'tag' => 'span'],
                    ]); ?>
                    
                    <?= $form->field($model, 'field23')->textInput(['class' => "special_form1 form-control selectpacketcommand"])->label(false); ?>
                    
                </td>
                <td id="getvarvalue1" class="hidetab" style="min-width: 180px;">
                    <!-- condition ---------------------------------- -->
                    <label id="getvarvalue1-label" class="control-label">Variable</label>&nbsp;
                        <?= PopoverX::widget([
                            'header' => false,
                            'size' => PopoverX::SIZE_LARGE,
                            'placement' => PopoverX::ALIGN_RIGHT_TOP,
                            'content' => '' ,
                            'footer' => false,
                            'toggleButton' => ['label'=>false, 'class'=>'glyphicon glyphicon-question-sign', 'tag' => 'span'],
                        ]); ?>
                    <?= $form->field($model, 'field24')->widget(Select2::classname(), [
                        'data' => $vars,
                        'pluginOptions' => [
                            'id' => 'getvarvalue1',
                        ]
                        ])->label(false); ?>    
                    
                </td>
                <td id="condition" class="hidetab" style="min-width: 180px;">
                    <!-- condition ---------------------------------- -->
                    <label class="control-label">Condition</label>&nbsp;
                        <?= PopoverX::widget([
                            'header' => false,
                            'size' => PopoverX::SIZE_LARGE,
                            'placement' => PopoverX::ALIGN_RIGHT_TOP,
                            'content' => '' ,
                            'footer' => false,
                            'toggleButton' => ['label'=>false, 'class'=>'glyphicon glyphicon-question-sign', 'tag' => 'span'],
                        ]); ?>
                    <?= $form->field($model, 'field25')->widget(Select2::classname(), [
                        'data' => $condition,
                        'pluginOptions' => [
                            'id' => 'selectcondition',
                            ]
                        ])->label(false); ?>
                </td>
                <td id="getvarvalue2" class="hidetab" style="min-width: 180px;">
                    <!-- condition ---------------------------------- -->
                    <label id="getvarvalue2-label" class="control-label">Variable</label>&nbsp;
                        <?= PopoverX::widget([
                            'header' => false,
                            'size' => PopoverX::SIZE_LARGE,
                            'placement' => PopoverX::ALIGN_RIGHT_TOP,
                            'content' => '' ,
                            'footer' => false,
                            'toggleButton' => ['label'=>false, 'class'=>'glyphicon glyphicon-question-sign', 'tag' => 'span'],
                        ]); ?>
                    <?= $form->field($model, 'field26')->widget(Select2::classname(), [
                        'data' => $vars,
                        'pluginOptions' => [
                            'id' => 'getvarvalue2',
                            ]
                        ])->label(false); ?>    
                    
                </td>
                <td id="gotoline" class="hidetab" class="hidetab" style="min-width: 160px;">
                    <!-- arg2 ---------------------------------- -->
                    <label id="gotoline-label" class="control-label">Go to line</label>&nbsp;
                    <?= PopoverX::widget([
                        'header' => false,
                        'options' => ['id' => 'options-area'],
                        'size' => PopoverX::SIZE_MEDIUM,
                        'placement' => PopoverX::ALIGN_LEFT_TOP,
                        'content' => '' ,
                        'footer' => false,
                        'toggleButton' => ['label'=>false, 'class'=>'glyphicon glyphicon-question-sign', 'tag' => 'span'],
                    ]); ?>
                    <?= $form->field($model, 'field27')->textInput(['class' => "special_form1 form-control selectpacketcommand"])->label(false); ?>
                    
                </td>
            </tr>
        </tbody>
        </table>
        <?= $form->field($model, 'field0')->hiddenInput(['value'=> 'nop','id' => 'bots-field0'])->label(false); ?>

        <?= $form->field($model, 'field1')->hiddenInput(['id' => 'bots-field1'])->label(false); ?>

        <?= $form->field($model, 'field2')->hiddenInput(['value'=> '60','id' => 'bots-field2'])->label(false); ?>

        <?= $form->field($model, 'field3')->hiddenInput(['id' => 'bots-field3'])->label(false); ?>
        
        <?= $form->field($model, 'field4')->hiddenInput(['id' => 'bots-field4'])->label(false); ?>

        <?= $form->field($model, 'field5')->hiddenInput(['id' => 'bots-field5'])->label(false); ?>

        <?= $form->field($model, 'field6')->hiddenInput(['id' => 'bots-field6'])->label(false); ?>

        <?= $form->field($model, 'field7')->hiddenInput(['id' => 'bots-field7'])->label(false); ?>


        <div class="form-group">
            <?= Html::submitButton('GO!', ['class' => 'btn btn-danger', 'style' => 'font-weight:bold;max-height:34px;']); ?>
        </div>
    <?php ActiveForm::end(); ?>

    

    <?php
    echo Collapse::widget([
        'autoCloseItems' => false,
        'options' => [
            'class' => 'botPageCollapse',
        ],
        'items' => [
            // equivalent to the above
            [
                'label' => 'Bot command builder...',
                'content' => Yii::$app->controller->renderPartial('_bots-command', ['model' => $model]),
                
            ],
            [
            'label' => 'Packet Commands',
            'content' => Yii::$app->controller->renderPartial('_expand-packetcommands',['model'=>$model]),
            'contentOptions' => ['class' => 'in'],
        ],
        ]
    ]);

    ?>

</div>

<?php Modal::begin([
    "id"=>"ajaxCrudModal",
    "footer"=>"",// always need it for jquery plugin
])?>
<?php Modal::end(); ?>


